/*
 * Decompiled with CFR 0.152.
 */
package filenet.pe.peorb.client;

import com.filenet.api.collection.GroupSet;
import com.filenet.api.collection.RealmSet;
import com.filenet.api.collection.UserSet;
import com.filenet.api.constants.FilteredPropertyType;
import com.filenet.api.constants.PrincipalSearchAttribute;
import com.filenet.api.constants.PrincipalSearchSortType;
import com.filenet.api.constants.PrincipalSearchType;
import com.filenet.api.core.Connection;
import com.filenet.api.core.EntireNetwork;
import com.filenet.api.core.Factory;
import com.filenet.api.property.PropertyFilter;
import com.filenet.api.security.Group;
import com.filenet.api.security.Realm;
import com.filenet.api.security.User;
import com.filenet.api.util.UserContext;
import com.filenet.apiimpl.util.J2EEUtil;
import filenet.vw.api.VWException;
import filenet.vw.base.logging.Logger;
import java.security.PrivilegedExceptionAction;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import javax.security.auth.Subject;

public class ORBIsMemberOfGroup
implements PrivilegedExceptionAction {
    static final String m_className = "ORBIsMemberOfGroup";
    protected static Logger logger = Logger.getLogger("filenet.pe.peorb.client");
    private static final long serialVersionUID = 464L;
    private static PropertyFilter pf = null;
    private String m_cempURI = null;
    private String m_groupToSearchFor = null;
    private String m_domainName = null;
    private String m_userName = null;
    private long m_RpcArgFlag = 0L;
    private Subject m_subject = null;

    public static String _get_FILE_DATE() {
        return "$Date:   03 Apr 2008 08:57:00  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   dlind  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.17  $";
    }

    protected ORBIsMemberOfGroup(String paramCEMPURL, String paramGroupName, String paramDomainName, String paramUserName, long paramRpcArgFlag) throws VWException {
        this.m_cempURI = paramCEMPURL;
        this.m_groupToSearchFor = paramGroupName;
        this.m_domainName = paramDomainName;
        this.m_userName = paramUserName;
        this.m_RpcArgFlag = paramRpcArgFlag;
    }

    protected void setSubject(Subject mySubject) {
        this.m_subject = mySubject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object runEx() throws VWException {
        Object object;
        if (this.m_cempURI != null && this.m_cempURI.equals("/FileNet/Local/Engine")) {
            return J2EEUtil.getInstance().doAs(this.m_subject, (PrivilegedExceptionAction)this);
        }
        UserContext old = UserContext.get();
        try {
            UserContext uc = new UserContext();
            uc.pushSubject(this.m_subject);
            UserContext.set((UserContext)uc);
            object = this.run();
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            UserContext.set((UserContext)old);
            throw throwable;
        }
        UserContext.set((UserContext)old);
        return object;
    }

    private boolean thisIsTheGroup(String groupShortName) {
        String m_method = "thisIsTheGroup";
        if (logger.isFinest()) {
            logger.finest(m_className, "thisIsTheGroup", " looking at group " + groupShortName + ", and looking for " + this.m_groupToSearchFor);
        }
        return groupShortName.toUpperCase(Locale.ENGLISH).equals(this.m_groupToSearchFor.toUpperCase(Locale.ENGLISH));
    }

    private boolean processGroups(GroupSet myGroups, HashSet alreadyProcessedGroups) {
        String m_method = "processGroups";
        if (myGroups == null) {
            return false;
        }
        Iterator groupIter = myGroups.iterator();
        Group group2 = null;
        while (groupIter.hasNext()) {
            group2 = (Group)groupIter.next();
            if (!this.thisIsTheGroup(group2.get_ShortName())) continue;
            if (logger.isFinest()) {
                logger.finest(m_className, "processGroups", "true: " + this.m_userName + " is a member of " + this.m_groupToSearchFor);
            }
            return true;
        }
        for (Group group2 : myGroups) {
            if (alreadyProcessedGroups.contains(group2.get_ShortName())) continue;
            alreadyProcessedGroups.add(group2.get_ShortName());
            GroupSet groups = null;
            try {
                groups = group2.get_MemberOfGroups();
            }
            catch (Throwable t) {
                logger.finest(m_className, "processGroups", "problem calling get_MemberOfGroups() for " + group2.get_ShortName() + ": " + t);
                groups = null;
            }
            if (!this.processGroups(groups, alreadyProcessedGroups)) continue;
            return true;
        }
        return false;
    }

    public Object run() throws VWException {
        String m_method = "run";
        logger.entering(m_className, "run");
        if (logger.isFinest()) {
            logger.finest(m_className, "run", "is " + this.m_userName + " a member of " + this.m_groupToSearchFor + "?");
        }
        Connection myConnection = Factory.Connection.getConnection((String)this.m_cempURI);
        EntireNetwork entireNetwork = Factory.EntireNetwork.fetchInstance((Connection)myConnection, null);
        RealmSet allRealms = entireNetwork.get_AllRealms();
        for (Realm realm : allRealms) {
            if (logger.isFinest()) {
                logger.finest(m_className, "run", "looking at realm " + realm.get_Name());
            }
            UserSet theUsers = realm.findUsers(this.m_userName, PrincipalSearchType.EXACT, PrincipalSearchAttribute.SHORT_NAME, PrincipalSearchSortType.ASCENDING, new Integer(0), pf);
            for (User user : theUsers) {
                HashSet alreadyProcessedGroups;
                GroupSet myGroups;
                if (!user.get_ShortName().toUpperCase(Locale.ENGLISH).equals(this.m_userName.toUpperCase(Locale.ENGLISH))) continue;
                if (logger.isFinest()) {
                    logger.finest(m_className, "run", "found " + this.m_userName + "; is he a member?");
                }
                if (!this.processGroups(myGroups = user.get_MemberOfGroups(), alreadyProcessedGroups = new HashSet())) continue;
                logger.exiting(m_className, "run");
                return new Boolean(true);
            }
        }
        if (logger.isFinest()) {
            logger.finest(m_className, "run", "false: " + this.m_userName + " is NOT a member of " + this.m_groupToSearchFor);
        }
        logger.exiting(m_className, "run");
        return new Boolean(false);
    }

    static {
        pf = new PropertyFilter();
        pf.addIncludeType(1, null, null, FilteredPropertyType.ANY);
        pf.addExcludeProperty("ClassDescriptions");
    }
}

